define(['app', 'angular'], function (app, angular) {
	"use strict";

	app.directive('notificationDeliveryOptions', function (NotificationsPreferencesService, formatter) {
		return {
			restrict: 'AE',
			require: 'ngModel',
			scope: {
				ngModel : '=',
				ngDisabled : '=',
                hideDay: '=',
                enableStartDate: '=?'
			},
			templateUrl: 'src/modules/trackers/pages/notification-status/notification-delivery-options/notification-delivery-options_template.html',

			link: function(scope, elem, attrs, ngModelCtrl) {
				scope.emailAddress = null;
				scope.isEmailAddressStored = null;
				scope.reminderTypes = [{ type:"In-App" }, { type:"Email" }];
				scope.notificationDates = ['Daily', 'Weekly', 'Monthly'];
				scope.notificationOptions = ["On", "Off"];
				scope.allowedDateRange = { min: '', max: '' };
				scope.allowedDateRange.min = formatter.getFormattedFrontendDate(new Date());
                scope.isStartDateEnabled = false;

				// for reminders in edit mode, reminders allow editing of fields other than startDate (which is disabled in edit mode)
				// so change allowedDateRange.min to prevent error stating the date must be today or later
				var unbindWatcher = scope.$watch('ngModel', function (newVal, oldVal) {
					if (newVal && newVal.link) {
						scope.isReminderEventDateStored = !!scope.ngModel.eventDate;
						unbindWatcher();
					}
				}, true);

				scope.errorHandling = {
					'deliverySelected': {
						message: 'A Notification Delivery method is needed to save this record. Please select a method and save again.',
						priority: 1
					}
				};

				(function init(){
					NotificationsPreferencesService.getPreferencesData().then(function (response) {
						scope.emailAddress = response.emailAddress;
						scope.isEmailAddressStored = !!response.emailAddress;
					}, function () {
						scope.isEmailAddressStored = false;
					}).finally(function (){
						if (!scope.isEmailAddressStored){
							scope.ngModel.notificationTypes.forEach(function (value, index) {
								if (value === "Email"){
									scope.ngModel.notificationTypes.splice(index, 1);
								}
							});
						}
					});
				})();

				// ================ HELPERS ================
				var validArrayValues = function (arr) {
					var validArray = arr.some(function (element) {
						return !!element;
					});

					return (validArray && arr.length > 0);
				};

				// ================ WATCHES ================
				scope.$watch('[ngModel.notificationTypes, ngModel.notificationStatus]', function (newVal) {
					if (scope.ngModel && scope.ngModel.notificationStatus === 'On') {
						ngModelCtrl.$setValidity('deliverySelected', validArrayValues(scope.ngModel.notificationTypes));
					} else {
						ngModelCtrl.$setValidity('deliverySelected', true);
					}
				}, true);

                scope.$watch('ngModel.notificationStatus', function (newVal, oldVal) {
                    if (scope.ngModel && newVal && oldVal && newVal !== oldVal && newVal === 'On') {
                        if(scope.enableStartDate) {
                            scope.isStartDateEnabled = true;
                        }
                    }
                }, true);

                scope.$watch('ngModel.eventDate', function (newVal, oldVal) {
                    if (scope.ngModel && newVal && newVal.length === 10) {
                        if (scope.isReminderEventDateStored && scope.ngModel.link && !scope.isStartDateEnabled) {
                            scope.allowedDateRange.min = null;
                        } else {
                            scope.allowedDateRange.min = formatter.getFormattedFrontendDate(new Date());
                        }
                    }
                }, true);

			}
		};
	});
});
